<?php

namespace App\Http\Controllers;

use App\GanhosAfiliado;
use App\Models\Product;
use App\RifaAfiliado;
use App\SolicitacaoAfiliado;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AfiliadoController extends Controller
{
    public function index()
    {

        if (Auth::check()) {
            $afiliadoId = Auth::user()->id;
            if (!Auth::user()->afiliado) {
                Auth::logout();
                return redirect()->route('afiliado.home');
            }


            $data = [
                'rifas' => Product::where('ganho_afiliado', '>', 0)->get()
            ];


    // Obter os ganhos de afiliados associados ao afiliado com o ID $afiliadoId
    $tix_dad = GanhosAfiliado::where('afiliado_id', $afiliadoId)->where('solicitacao_id', null)->get();
    $tix_pendentes   = GanhosAfiliado::where('afiliado_id', $afiliadoId)->where('afiliado_id','=',$afiliadoId)->get();
    $tix_solicitac   = GanhosAfiliado::where('afiliado_id', $afiliadoId)->where('solicitacao_id','>',0)->get();
    $tix_valoreceber = GanhosAfiliado::where('afiliado_id', $afiliadoId)->where('solicitacao_id', null)->get();


$tix_youtube = User::where('id', 1)->first();

    // Calcular o valor total dos ganhos
    $valor_do_ganho_total = $tix_dad->sum('valor');  
    $affiliados_tix = $tix_pendentes->count('afiliado_id');
    $tix_solicita = $tix_solicitac->count('solicitacao_id');
    $tix_valorebe = $tix_valoreceber->count('solicitacao_id');
    
    // Passar os dados para a view
   return view('afiliados.home', [
    'tix_youtube'           => $tix_youtube,
    'valor_do_ganho_total'  => $valor_do_ganho_total,
    'tix_pendentes'         => $tix_pendentes,
    'tix_solicitac'         => $tix_solicitac,
    'tix_valoreceber'       => $tix_valorebe,
    'affiliados_tix'        => $affiliados_tix,
    'tix_solicita'          => $tix_solicita
]);
    return view('afiliados.home', ['tix_ganhos' => $tix_ganhos]);

    return view('afiliados.home', $data);


            
        } else {
            return view('afiliados.login');
        }
        
    }

    public function rifasAtivas()
    {
        $data = [
            'rifas' => Product::where('ganho_afiliado', '>', 0)->where('status', '=', 'Ativo')->get()
        ];

        return view('afiliados.rifasAtivas', $data);
    }

    public function login(Request $request)
    {
        $credentials = [
            'email' => $request->email,
            'password' => $request->password,
            'afiliado' => true
        ];

        if (Auth::attempt($credentials)) {

            return redirect()->route('afiliado.home');
        }

        return back()->withInput()->withErrors('Usuário e/ou Senha incorretos');
    }

    public function cadastro()
    {
        return view('afiliados.cadastro');
    }

    public function novo(Request $request)
    {
        if ($request->senha != $request->conf_senha) {
            return back()->withInput()->withErrors('Senhas não conferem!');
        }

        if (User::where('email', '=', $request->email)->get()->count() > 0) {
            return back()->withInput()->withErrors('Email já possui cadastro!');
        }

        $user = User::create([
            'name' => $request->nome,
            'email' => $request->email,
            'telephone' => '',
            'status' => '1',
            'password' => bcrypt($request->senha),
            'cpf' => $request->cpf,
            'pix' => $request->pix,
            'afiliado' => true
        ]);

        Auth::login($user);

        return redirect()->route('afiliado.home');
    }

    public function home()
    {


        
    return view('afiliados.home', $data);
       
       
    }

    public function logout()
    {
        Auth::logout();

        return redirect()->route('afiliado.home');
    }

    public function pagamentos()
    {
        $ganhos = GanhosAfiliado::select('ganhos_afiliados.*')
            ->join('participant', 'participant.id', '=', 'ganhos_afiliados.participante_id')
            ->where('afiliado_id', '=', Auth::user()->id)
            ->where('participant.pagos', '>', 0)
            ->get();

        $data = [
            'ganhos' => $ganhos,
            'disponivel' => $ganhos->where('solicitacao_id', '=', null)->sum('valor'),
            'solicitado' => $ganhos->where('solicitacao_id', '!=', null)->where('pago', '=', false)->sum('valor'),
            'recebido' => $ganhos->where('solicitacao_id', '!=', null)->where('pago', '=', true)->sum('valor'),
        ];


        return view('afiliados.pagamentos', $data);
    }

    public function afiliar($idRifa)
    {
        RifaAfiliado::create([
            'product_id' => $idRifa,
            'afiliado_id' => Auth::user()->id,
            'token' => uniqid()
        ]);

        return back()->with(['message' => 'Afiliado com sucesso!']);
    }

    public function solicitarSaque()
    {
        try {
            $afiliadoId = Auth::user()->id;

            $ganhosPendentes = GanhosAfiliado::where('afiliado_id', '=', $afiliadoId)->where('solicitacao_id', '=', null)->sum('valor');
            if ($ganhosPendentes == 0) {
                return back()->withErrors('Você não tem nenhum valor disponível para saque!');
            }

            $solicitacao = SolicitacaoAfiliado::create([
                'afiliado_id' => $afiliadoId
            ]);

            GanhosAfiliado::where('afiliado_id', '=', $afiliadoId)->update([
                'solicitacao_id' => $solicitacao->id
            ]);

            return back()->with(['message' => 'Solicitação de saque realizada com sucesso!']);
        } catch (\Throwable $th) {
            dd($th);
            return back()->withErrors('Erro interno no sistema!');
        }
    }
}
